//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;

namespace Testing
{
	struct Complex
	{
		double real;
		double imag;
		public override string ToString()
		{
			return (string.Format("({0}, {1}i)", real, imag));
		}
		
		public static bool operator==(Complex a, Complex b)
		{
			if(a.real == b.real &&
				a.imag == b.imag)
			{
				return(true);
			}
			else
			{
				return(false);
			}
		}
		public static bool operator!=(Complex a, Complex b)
		{
			return(!(a == b));
		}
		public override bool Equals(object o)
		{
			Complex b = (Complex)o;
			return(this == b);
		}
		public override int GetHashCode()
		{
			return (real.GetHashCode() ^ imag.GetHashCode());
		}
		public static Complex operator+(Complex a, Complex b)
		{
			Complex r = new Complex();
			r.real = a.real + b.real;
			r.imag = a.imag + b.imag;
			return(r);
		}
		public static Complex operator+(Complex a)
		{
			Complex r = new Complex();
			r.real = a.real;
			r.imag = a.imag;
			return(r);
		}
		public static Complex operator-(Complex a)
		{
			Complex r = new Complex();
			r.real = -a.real;
			r.imag = -a.imag;
			return(r);
		}
		public double Real
		{
			get
			{
				return real;
			}
			set
			{
				real = value;
			}
		}
		public double Imaginary
		{
			get
			{
				return imag;
			}
			set
			{
				imag = value;
			}
		}
	}
	
	class HelloMain
	{
		static void ComplexOutput(object o)
		{
			Complex cn = (Complex)o;
			Console.WriteLine("{0}", cn);
		}
		static void Main(string[] args)
		{
			Complex cn = new Complex();
			cn.Real = 1;
			cn.Imaginary = 0;
			Console.WriteLine("{0}", cn);
			Complex cnn = -cn;
			Console.WriteLine("{0}", cnn);
			int i = 0;
			uint si = 0;
			long l = 0;
			ulong ul = 0;
			decimal d = 0;
			float fp = 0;
			double dp = 0;
			Console.WriteLine("{0} {1} {2}", i.GetType(), 
				int.MinValue,
				int.MaxValue);
			Console.WriteLine("{0} {1} {2}", si.GetType(), 
				uint.MinValue,
				uint.MaxValue);
			Console.WriteLine("{0} {1} {2}", l.GetType(), 
				long.MinValue,
				long.MaxValue);
			Console.WriteLine("{0} {1} {2}", ul.GetType(), 
				ulong.MinValue,
				ulong.MaxValue);
			Console.WriteLine("{0} {1} {2}", d.GetType(), 
				decimal.MinValue,
				decimal.MaxValue);
			Console.WriteLine("{0} {1} {2}", fp.GetType(), 
				float.MinValue,
				float.MaxValue);
			Console.WriteLine("{0} {1} {2}", dp.GetType(), 
				double.MinValue,
				double.MaxValue);
			Console.WriteLine("{0}", cn);
			Complex cna = new Complex();
			cna.Real = 1;
			cna.Imaginary = 0;
			Complex cnb = new Complex();
			cnb.Real = 0;
			cnb.Imaginary = 1;
			Console.WriteLine("{0} {1} {2}", cna == cnb, cna.Equals(cnb), cna != cnb);
			Console.WriteLine("{0}", cna + cnb);
		}
	}
}
